/*************************************************************************
 * DISCLAIMER                                                            *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/
/*******************************************************************
  Copyright (c) 2007 Freescale Semiconductor
  \file     	Main.c
  \brief    	Smart Card Reader for MC9S08JM60
  \author   	Freescale Semiconductor
  \version    0.1
  \date     	15/Aug/2011
*********************************************************************/

#pragma MESSAGE DISABLE C4002 /* WARNING C4002: Result not used is ignored */

#include "SCI.h"


byte SCI1_RecvChar(byte *Chr, unsigned long TimeOut)
{
  while(!SCI1S1_RDRF && --TimeOut);
  if(TimeOut == 0)
    return ERROR; 
   
  *Chr = SCI1D;                   // Read data from the receiver
  return SUCCESS;
}

 // SCI1C3 &= ~SCI1C3_TXDIR_MASK;  
 
void SCI1_SendChar(byte Chr)
{ 
  SCI1C2_RE = 0;                  // Disable Rx    
  SCI1C3_TXDIR = 1;               // TxD pin as output in single-wire mode               
  (void)SCI1S1;                   // Reset interrupt request flag
  while(!SCI1S1_TDRE);
  SCI1D = (byte)Chr;              // Store char to the transmitter register
  while(!SCI1S1_TC);
  
  SCI1C2_RE = 1;                  // Enable Rx
  SCI1C3_TXDIR = 0;               // TxD pin as input in single-wire mode   
  SCI1S1_RDRF = 0;                // Clear the SCI1 receive buffer
}


void SCI1_Init(void)
{
  
  // M=1,PE=1,PT=0 
  PTEDD_PTEDD1 = 0;               // RxD1
  PTEDD_PTEDD0 = 1;               // TxD1
  
  SCI1C1 = 0xF2;                  // 9bit mode, even parity, single-wire mode
  
  SCI1C3 = 0x00;                  // Disable error interrupts, TXDIR = 0.
  
  SCI1S2 = 0x00;                
  
  
  SCI1BDH = 0x01;
  SCI1BDL = 0x74;         // 4032 bps based on 24MHz bus frequency
  
  SCI1C2 = 0x00;          // Disable all interrupts
  // Enable transmitter, Enable receiver
  SCI1C2 |= (SCI1C2_TE_MASK | SCI1C2_RE_MASK); 
}


